﻿using System;
using System.Reflection;
using System.Threading;
using VBECS.Services.Common.Timing;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.Log;
using IServer = gov.va.med.vbecs.Common.IServer;
using IServerInner = VBECS.Services.Common.Timing.IServer;

namespace gov.va.med.VBECS.NaiveExample
{
    /// <summary>
    /// Implements Simple Example for timing job
    /// </summary>
    internal class Server : IServer
    {
        public event EventHandler<ThreadExceptionEventArgs> FatalErrorOccured;
        // Inner server
        private IServerInner _server;
        // Logger
        private readonly ILogger _logger =
            LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

        public void Start()
        {
            if (_server != null) return; // The server is already started

            // Read timeout from configuration
            var timeOut = (int)GlobalContext.Instance().AppSettingsReader.GetValue("TimeOut", typeof (int));
            // TODO: assign server using Spring.NET or Factory
            _server = new SynchronousServer(timeOut);
            _server.TimeoutElapsed += ServerOnTimeoutElapsed;
            _server.Start();
            _logger.Debug("A server started");
        }

        private void ServerOnTimeoutElapsed(object sender, EventArgs eventArgs)
        {
            _logger.Info("Ping");
        }

        public void Stop()
        {
            if (_server == null) return; // The server is not started
            _server.Stop();
            _server = null;
        }
    }
}
